// File created 2005-06-14 14:33:11
using System;
using System.Collections;
using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.UmlCodeAttributes;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.ObjectRepresentation;
namespace CustomOclOperations
{


	[UmlElement("Package", Id="d506353f-d9e8-42ce-be5a-3274b7205e69")]
	[UmlMetaAttribute("ownedElement", typeof(Account))]
	[UmlMetaAttribute("ownedElement", typeof(Person))]
	[EcoCodeGenVersion("2.0")]
	public class CoreClassesPackage
	{
		[UmlElement("Association", Id="b21a0155-dd16-4970-b517-550cebcaedad")]
		public class Association_1
		{
		}
	}

	[UmlElement(Id="582e2464-4b55-46ef-8daa-44fa88bd2d78")]
	public class Account : ILoopBack
	{
		#region ECO generated code
		public class AccountListAdapter : ObjectListAdapter, IAccountList
		{
			public AccountListAdapter(IList source) : 
					base(source)
			{
			}
			public Account this[int index]
			{
				get
				{
					return ((Account)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Account value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Account value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Account value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Account value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Account value)
			{
				this.Adaptee.Remove(value);
			}
		}
		protected IContent eco_Content;
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		public Account(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 2);
			public const int Assets = Eco_FirstMember;
			public const int Person = (Assets + 1);
		}
		#endregion ECO generated code
		public Account(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="32811658-be63-4730-880c-ead452cc3a52", Index=Eco_LoopbackIndices.Assets)]
		public double Assets
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Assets)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Assets, ((object)(value)));
			}
		}
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Association_1), Index=1)]
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Person, Id="4a79b4ae-3add-470e-bfdd-a480789f9658")]
		[UmlMetaAttribute("multiplicity", "1")]
		public Person Person
		{
			get
			{
				return ((Person)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Person)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Person, ((object)(value)));
			}
		}
	}

	[UmlCollection(typeof(Account))]
	public interface IAccountList : ICollection
	{
		#region ECO generated code
		Account this[int index]
		{
			get;
			set;
		}
		int Add(Account value);
		bool Contains(Account value);
		int IndexOf(Account value);
		void Insert(int index, Account value);
		void Remove(Account value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlElement(Id="c6672104-ac72-4620-b468-8175f8311648")]
	public class Person : ILoopBack
	{
		#region ECO generated code
		public class PersonListAdapter : ObjectListAdapter, IPersonList
		{
			public PersonListAdapter(IList source) : 
					base(source)
			{
			}
			public Person this[int index]
			{
				get
				{
					return ((Person)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Person value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Person value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Person value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Person value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Person value)
			{
				this.Adaptee.Remove(value);
			}
		}
		protected IContent eco_Content;
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		public Person(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 2);
			public const int Name = Eco_FirstMember;
			public const int Accounts = (Name + 1);
		}
		#endregion ECO generated code
		public Person(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="b52dbb07-658a-4fb9-a1f3-357cbac84aa7", Index=Eco_LoopbackIndices.Name)]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Association_1), Index=0)]
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Accounts, Id="eca8b38a-538e-4668-9190-c0c74ced456f")]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IAccountList Accounts
		{
			get
			{
				return new Account.AccountListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Accounts))));
			}
		}
		[UmlElement(Id="4072e965-1461-420a-8ce7-dfea6697358c")]
		public bool IsRich()
		{
			double sum = 0;
			foreach (Account a in Accounts as IList)
			{
				sum = sum + a.Assets;
			}
			return sum > 1000;
		}
		
		[UmlElement(Id="9540b293-ab93-4721-b29c-9be962ea3973")]
		public double AssetsInCurrency(double exchangeRate)
		{
			double sum = 0;
			foreach (Account a in Accounts as IList)
			{
				sum = sum + a.Assets;
			}
			return sum*exchangeRate;
		}
	}

	[UmlCollection(typeof(Person))]
	public interface IPersonList : ICollection
	{
		#region ECO generated code
		Person this[int index]
		{
			get;
			set;
		}
		int Add(Person value);
		bool Contains(Person value);
		int IndexOf(Person value);
		void Insert(int index, Person value);
		void Remove(Person value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
}


